<?php
namespace Jet_Popup\Compatibility;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Compatibility Manager
 */
class Jet_Form_Builder {

	/**
	 * Include files
	 */
	public function load_files() {}


	/**
	 * @param $conditions_sub_group_list
	 *
	 * @return array|object
	 */
	public function modify_elementor_render_data( $render_data, $popup_id, $elementor_widgets ) {

		if ( wp_doing_ajax() || ( defined( 'REST_REQUEST' ) && REST_REQUEST ) ) {

			if ( in_array('jet-form-builder-form', $elementor_widgets ) ) {
				$render_data['scripts']['jet-form-builder-sortable'] = \Jet_Form_Builder\Plugin::instance()->plugin_url( 'assets/lib/jquery-sortable/sortable.js' );
				$render_data['scripts']['jet-form-builder-file-upload'] = \Jet_Form_Builder\Plugin::instance()->plugin_url( 'assets/js/file-upload.js' );
				$render_data['styles']['jet-form-builder-front-css'] = \Jet_Form_Builder\Plugin::instance()->plugin_url( 'assets/css/frontend.css' );
			}

		}

		return $render_data;
	}

	/**
	 * [__construct description]
	 */
	public function __construct() {

		if ( ! defined( 'JET_FORM_BUILDER_VERSION' ) ) {
			return false;
		}

		$this->load_files();

		add_filter( 'jet-popup/elementor-render/render-data', [ $this, 'modify_elementor_render_data' ], 10, 4 );

		if ( jet_popup()->generator->ajax_popup_defined ) {
			add_action( 'wp_enqueue_scripts', [ \Jet_Form_Builder\Plugin::instance()->blocks, 'enqueue_frontend_assets' ] );
		}

	}

}
